      FUNCTION X02AEF(DUM)
C
C     FUNCTION TO RETURN LARGEST NEGATIVE NUMBER
C     FOR WHICH EXP(X) DOES NOT UNDERFLOW
C     THIS VERSION IS FOR SUN DOUBLE PRECISION
C
      DOUBLE PRECISION X02AEF,A, DUM
C     VALUE FOR VAX DOUBLE PRECISION
C     DATA A/-88.49D0/
C     VALUE FOR IBM DOUBLE PRECISION
C     DATA A/??/
C     VALUE FOR SUN DOUBLE PRECISION
      DATA A/-745.D0/
      X02AEF=A
      RETURN
      END

      INTEGER FUNCTION P01AAF(ISAVE,IFAIL,SRNAME)
      CHARACTER(8) SRNAME
      P01AAF=IFAIL
      IF (ISAVE.GE.1) RETURN
      WRITE(6,601) SRNAME,IFAIL
  601 FORMAT(//' ****** NAG ROUTINE ',A8,' FAILS WITH IFAIL =',I2)
      STOP
      END


      SUBROUTINE D01BAW(A, B, ITYPE, NPTS, WEIGHT, ABSCIS, IFAIL)
C     MARK 7 RELEASE. NAG COPYRIGHT 1978.
C
C     RETURNS WEIGHTS AND PIVOTS FOR ONE GAUSS-HERMITE FORMULA IF
C     STORED
C     IFAIL = 1 - THE NPTS RULE IS NOT AMONG THOSE STORED
C     ( WEIGHT,ABSCIS EVALUATED FOR LARGEST VALID NPTS LESS THAN
C     REQUESTED VALUE)
C     IFAIL = 2 - B IS NOT POSITIVE
C     ( ALL WEIGHTS AND ABSCISSAE RETURNED AS ZERO)
C     IFAIL = 3 - UNDERFLOW IN EVALUATING NORMAL WEIGHTS
C     ( UNDERFLOWING WEIGHTS RETURNED AS ZERO)
C
C     THE WEIGHTS AND ABSCISSAE RETURNED DEPEND ON A AND B.
C     THOSE STORED ARE ADJUSTED WEIGHTSAND ABSCISSAE FOR A=0,B=1
C     THOSE RETURNED FOR GENERAL (A,B) ARE RELATED TO THOSE STORED
C     BY
C     X(A,B) = X(0,1) / SQRT(B) + A
C     W(A,B) = W(0,1) / SQRT(B)            ADJUSTED WEIGHT
C     W(A,B) = W(0,1) / SQRT(B) * EXP(-X(0,1)**2)     NORMAL WEIGHT
C
C     .. SCALAR ARGUMENTS ..
      DOUBLE PRECISION A, B
      INTEGER IFAIL, ITYPE, NPTS
C     .. ARRAY ARGUMENTS ..
      DOUBLE PRECISION ABSCIS(NPTS), WEIGHT(NPTS)
C     ..
C     .. LOCAL SCALARS ..
      DOUBLE PRECISION ACON, BCON, EXPMIN, EXPNOW
      INTEGER I, IIJJ, N, NL, NN, NPTSA
C     .. LOCAL ARRAYS ..
      DOUBLE PRECISION ABST(136), WTST(136)
      INTEGER NSTOR(16)
C     .. FUNCTION REFERENCES ..
      DOUBLE PRECISION DLOG, DEXP, DSQRT, X02AEF
C     ..
      DATA WTST( 1),WTST( 2),WTST( 3),WTST( 4),WTST( 5)/+
     *0.177245385090551602729816748334D  1,+
     *0.146114118266113893227081153805D  1,+
     *0.132393117521364417982145369574D  1,+
     *0.118163590060367735153211165556D  1,+
     *0.124022581769581582313602133630D  1/
      DATA WTST( 6),WTST( 7),WTST( 8),WTST( 9),WTST(10)/+
     *0.105996448289496919467700082632D  1,+
     *0.118148862553598760450064257103D  1,+
     *0.986580996751428170493791000893D  0,+
     *0.945308720482941881225689324448D  0,+
     *0.113690833267452455023236790713D  1/
      DATA WTST(11),WTST(12),WTST(13),WTST(14),WTST(15)/+
     *0.935580557631180516030739597771D  0,+
     *0.876401334436230560398288584873D  0,+
     *0.107193014424797975646401548286D  1,+
     *0.866752606563381222217794517844D  0,+
     *0.792890048386401250905646706509D  0/
      DATA WTST(16),WTST(17),WTST(18),WTST(19),WTST(20)/+
     *0.764544128651729199071391485062D  0,+
     *0.102545169136573723302060214399D  1,+
     *0.820666126404816614571910879903D  0,+
     *0.741441931943564970082047701889D  0,+
     *0.703296323104906170098341726820D  0/
      DATA WTST(21),WTST(22),WTST(23),WTST(24),WTST(25)/+
     *0.687081853951273362686567184226D  0,+
     *0.989699047092298099365013260061D  0,+
     *0.786643939463322464491538074354D  0,+
     *0.705220366112219755755671548199D  0,+
     *0.662662773266871319239255150461D  0/
      DATA WTST(26),WTST(27),WTST(28),WTST(29),WTST(30)/+
     *0.639621232020256600669349916231D  0,+
     *0.629307874369492821035718831851D  0,+
     *0.960878703025659256530957856273D  0,+
     *0.759987087397566080063276151314D  0,+
     *0.677706759192397010397799872260D  0/
      DATA WTST(31),WTST(32),WTST(33),WTST(34),WTST(35)/+
     *0.632900606472333090829237871000D  0,+
     *0.606379739126097487205260334359D  0,+
     *0.591106667043162424830256106168D  0,+
     *0.584061690521996239000758325930D  0,+
     *0.936874492884069357470004849342D  0/
      DATA WTST(36),WTST(37),WTST(38),WTST(39),WTST(40)/+
     *0.738245622277681359882790450735D  0,+
     *0.655755672876117706470598922177D  0,+
     *0.609736958255997285624299714816D  0,+
     *0.581247275400863892026244221842D  0,+
     *0.563217829088199837712368695264D  0/
      DATA WTST(41),WTST(42),WTST(43),WTST(44),WTST(45)/+
     *0.552441957367459390415739574435D  0,+
     *0.547375205037843999281961634810D  0,+
     *0.898591961453191416420545454828D  0,+
     *0.704332961176942408713820400283D  0,+
     *0.622278696191412280649317396569D  0/
      DATA WTST(46),WTST(47),WTST(48),WTST(49),WTST(50)/+
     *0.575262442852503182139156253731D  0,+
     *0.544851742364520005199359051276D  0,+
     *0.524080350948557612676557263766D  0,+
     *0.509679027117458006672866659919D  0,+
     *0.499920871336290517264977963932D  0/
      DATA WTST(51),WTST(52),WTST(53),WTST(54),WTST(55)/+
     *0.493843385272052927814608991998D  0,+
     *0.490921500666745824279594295608D  0,+
     *0.868875565091689911673293675820D  0,+
     *0.678574662290107339978535617442D  0,+
     *0.597391700440043782447148863489D  0/
      DATA WTST(56),WTST(57),WTST(58),WTST(59),WTST(60)/+
     *0.550207547397842546030013376905D  0,+
     *0.519043867583032989632271181604D  0,+
     *0.497076692865752223545562843831D  0,+
     *0.481072202833053294709260045854D  0,+
     *0.469284885626489034198810456724D  0/
      DATA WTST(61),WTST(62),WTST(63),WTST(64),WTST(65)/+
     *0.460693909629746785985665099229D  0,+
     *0.454675477135121353867147656635D  0,+
     *0.450846100819996514865756523030D  0,+
     *0.448982845326226109726265246095D  0,+
     *0.824566523065655139056305722524D  0/
      DATA WTST(66),WTST(67),WTST(68),WTST(69),WTST(70)/+
     *0.640950485913829309224087772673D  0,+
     *0.561749014649764782398926913003D  0,+
     *0.515037284667146647430741671573D  0,+
     *0.483571440736107139445169061833D  0,+
     *0.460786455690955139026733402184D  0/
      DATA WTST( 71),WTST( 72),WTST( 73),WTST( 74),WTST( 75)/+
     *0.443553185501410843028238668408D  0,+
     *0.430163710880612661826154332952D  0,+
     *0.419597753081150804947789020760D  0,+
     *0.411206128712310155343092650551D  0,+
     *0.404557061796617160693998299314D  0/
      DATA WTST( 76),WTST( 77),WTST( 78),WTST( 79),WTST( 80)/+
     *0.399354844618449389544597768000D  0,+
     *0.395393939396172377687363613476D  0,+
     *0.392531864365819903660931165803D  0,+
     *0.390672744628543125976647215992D  0,+
     *0.389757342027438731932682765057D  0/
      DATA WTST( 81),WTST( 82),WTST( 83),WTST( 84),WTST( 85)/+
     *0.766876368495238274746411051044D  0,+
     *0.593128455631209585878126597175D  0,+
     *0.517445935842046958048825686801D  0,+
     *0.472277449549521321867721596361D  0,+
     *0.441405136853915738519768767287D  0/
      DATA WTST( 86),WTST( 87),WTST( 88),WTST( 89),WTST( 90)/+
     *0.418643762410651395960265975190D  0,+
     *0.401037665458882553379674293048D  0,+
     *0.386967139217075008041181017180D  0,+
     *0.375458352846498342591218999274D  0,+
     *0.365885220494083772716610708913D  0/
      DATA WTST( 91),WTST( 92),WTST( 93),WTST( 94),WTST( 95)/+
     *0.357824345486808042028607717718D  0,+
     *0.350977930538897867605721029693D  0,+
     *0.345129911413373110866703372437D  0,+
     *0.340119598454938889487779018765D  0,+
     *0.335825120387576070820832052751D  0/
      DATA WTST( 96),WTST( 97),WTST( 98),WTST( 99),WTST(100)/+
     *0.332152637910123377750889027753D  0,+
     *0.329029100292743088147440929506D  0,+
     *0.326397258658636261497700089513D  0,+
     *0.324212164105044746879770317833D  0,+
     *0.322438672438255669417772078051D  0/
      DATA WTST(101),WTST(102),WTST(103),WTST(104),WTST(105)/+
     *0.321049651285514786202103413506D  0,+
     *0.320024692056773847195880277680D  0,+
     *0.319349196902419087447733515776D  0,+
     *0.319013755285312385825621915982D  0,+
     *0.728927208690448427742110375683D  0/
      DATA WTST(106),WTST(107),WTST(108),WTST(109),WTST(110)/+
     *0.562255561656448726802887082512D  0,+
     *0.489326444740731915235376894508D  0,+
     *0.445579328497246221345783916011D  0,+
     *0.415503913204160831669677232455D  0,+
     *0.393180736318882184851902579711D  0/
      DATA WTST(111),WTST(112),WTST(113),WTST(114),WTST(115)/+
     *0.375778926542059581956812824873D  0,+
     *0.361745661531460261101060426381D  0,+
     *0.350146138450335332748577866176D  0,+
     *0.340378325558398342073645322743D  0,+
     *0.332034121660959831597172057861D  0/
      DATA WTST(116),WTST(117),WTST(118),WTST(119),WTST(120)/+
     *0.324825535546719088610765834044D  0,+
     *0.318542654113848743235199368676D  0,+
     *0.313028363535617904475039006475D  0,+
     *0.308162449185309597110102248845D  0,+
     *0.303851213837657558658155179366D  0/
      DATA WTST(121),WTST(122),WTST(123),WTST(124),WTST(125)/+
     *0.300020481151580296697435447362D  0,+
     *0.296610751157979998401894795218D  0,+
     *0.293573766485027313963221076049D  0,+
     *0.290870028592030296329129560635D  0,+
     *0.288466969153227589575235356344D  0/
      DATA WTST(126),WTST(127),WTST(128),WTST(129),WTST(130)/+
     *0.286337582975828641347074702920D  0,+
     *0.284459392399569721310680757112D  0,+
     *0.282813654050477159948319322829D  0,+
     *0.281384745779077791730100909906D  0,+
     *0.280159689744734105675726026292D  0/
      DATA WTST(131),WTST(132),WTST(133),WTST(134),WTST(135)/+
     *0.279127780042487258712648370028D  0,+
     *0.278280291956949764070907305894D  0,+
     *0.277610256111740156146566249797D  0,+
     *0.277112285270899476074163167412D  0,+
     *0.276782444877604386788636614272D  0/
      DATA WTST(136)/+0.276618160950139556162846622036D   0/
      DATA ABST( 1),ABST( 2),ABST( 3),ABST( 4),ABST( 5)/+
     *0.000000000000000000000000000000D  0,+
     *0.707106781186547524400844362104D  0,+
     *0.122474487139158904909864203735D+ 1,+
     *0.000000000000000000000000000000D  0,+
     *0.165068012388578455588334111112D+ 1/
      DATA ABST( 6),ABST( 7),ABST( 8),ABST( 9),ABST(10)/+
     *0.524647623275290317884060253834D  0,+
     *0.202018287045608563292872408814D+ 1,+
     *0.958572464613818507112770593892D  0,+
     *0.000000000000000000000000000000D  0,+
     *0.235060497367449222283392198706D+ 1/
      DATA ABST(11),ABST(12),ABST(13),ABST(14),ABST(15)/+
     *0.133584907401369694971489528297D+ 1,+
     *0.436077411927616508679215948250D  0,+
     *0.293063742025724401922350270524D+ 1,+
     *0.198165675669584292585463063976D+ 1,+
     *0.115719371244678019472076577906D+ 1/
      DATA ABST(16),ABST(17),ABST(18),ABST(19),ABST(20)/+
     *0.381186990207322116854718885583D  0,+
     *0.343615911883773760332672549431D+ 1,+
     *0.253273167423278979640896079775D+ 1,+
     *0.175668364929988177345140122010D+ 1,+
     *0.103661082978951365417749191675D+ 1/
      DATA ABST(21),ABST(22),ABST(23),ABST(24),ABST(25)/+
     *0.342901327223704608789165025557D  0,+
     *0.388972489786978191927164274724D+ 1,+
     *0.302063702512088977171067937517D+ 1,+
     *0.227950708050105990018772856942D+ 1,+
     *0.159768263515260479670966277090D+ 1/
      DATA ABST(26),ABST(27),ABST(28),ABST(29),ABST(30)/+
     *0.947788391240163743704578131060D  0,+
     *0.314240376254359111276611634095D  0,+
     *0.430444857047363181262129810036D+ 1,+
     *0.346265693360227055020891736115D+ 1,+
     *0.274847072498540256862499852414D+ 1/
      DATA ABST(31),ABST(32),ABST(33),ABST(34),ABST(35)/+
     *0.209518325850771681573497272630D+ 1,+
     *0.147668273114114087058350654420D+ 1,+
     *0.878713787329399416114679311860D  0,+
     *0.291745510672562078446113075799D  0,+
     *0.468873893930581836468849864874D+ 1/
      DATA ABST(36),ABST(37),ABST(38),ABST(39),ABST(40)/+
     *0.386944790486012269871942409801D+ 1,+
     *0.317699916197995602681399455926D+ 1,+
     *0.254620215784748136215932870544D+ 1,+
     *0.195178799091625397743465541495D+ 1,+
     *0.138025853919888079637208966969D+ 1/
      DATA ABST(41),ABST(42),ABST(43),ABST(44),ABST(45)/+
     *0.822951449144655892582454496733D  0,+
     *0.273481046138152452158280401965D  0,+
     *0.538748089001123286201690041068D+ 1,+
     *0.460368244955074427307767524897D+ 1,+
     *0.394476404011562521037562880052D+ 1/
      DATA ABST(46),ABST(47),ABST(48),ABST(49),ABST(50)/+
     *0.334785456738321632691492452299D+ 1,+
     *0.278880605842813048052503375640D+ 1,+
     *0.225497400208927552308233334473D+ 1,+
     *0.173853771211658620678086566213D+ 1,+
     *0.123407621539532300788581834695D+ 1/
      DATA ABST(51),ABST(52),ABST(53),ABST(54),ABST(55)/+
     *0.737473728545394358705605144252D  0,+
     *0.245340708300901249903836530633D  0,+
     *0.601592556142573971734857350898D+ 1,+
     *0.525938292766804436743072304398D+ 1,+
     *0.462566275642378726504864923776D+ 1/
      DATA ABST(56),ABST(57),ABST(58),ABST(59),ABST(60)/+
     *0.405366440244814950394766297923D+ 1,+
     *0.352000681303452471128987227608D+ 1,+
     *0.301254613756556482565453858420D+ 1,+
     *0.252388101701142697419907602332D+ 1,+
     *0.204900357366169891178708399532D+ 1/
      DATA ABST(61),ABST(62),ABST(63),ABST(64),ABST(65)/+
     *0.158425001096169414850563336201D+ 1,+
     *0.112676081761124507213306126773D+ 1,+
     *0.674171107037212236000245923730D  0,+
     *0.224414547472515585151136715526D  0,+
     *0.712581390983072757279520760342D+ 1/
      DATA ABST(66),ABST(67),ABST(68),ABST(69),ABST(70)/+
     *0.640949814926966041217376374152D+ 1,+
     *0.581222594951591383276596615365D+ 1,+
     *0.527555098651588012781906048139D+ 1,+
     *0.477716450350259639303579405688D+ 1,+
     *0.430554795335119844526348653193D+ 1/
      DATA ABST( 71),ABST( 72),ABST( 73),ABST( 74),ABST( 75)/+
     *0.385375548547144464388787292109D+ 1,+
     *0.341716749281857073587392729563D+ 1,+
     *0.299249082500237420628549407606D+ 1,+
     *0.257724953773231745403092930114D+ 1,+
     *0.216949918360611217330570559501D+ 1/
      DATA ABST( 76),ABST( 77),ABST( 78),ABST( 79),ABST( 80)/+
     *0.176765410946320160462767325852D+ 1,+
     *0.137037641095287183816170564864D+ 1,+
     *0.976500463589682838484704871981D  0,+
     *0.584978765435932448466957544011D  0,+
     *0.194840741569399326708741289532D  0/
      DATA ABST( 81),ABST( 82),ABST( 83),ABST( 84),ABST( 85)/+
     *0.897531508193168706215358223476D+ 1,+
     *0.831075219070478413034784782669D+ 1,+
     *0.775929551976577463923770264126D+ 1,+
     *0.726604655416435040282062777182D+ 1,+
     *0.681006457807414138661792830623D+ 1/
      DATA ABST( 86),ABST( 87),ABST( 88),ABST( 89),ABST( 90)/+
     *0.638056409618641062386710795477D+ 1,+
     *0.597107222501354540770712331894D+ 1,+
     *0.557731698122372862626895168708D+ 1,+
     *0.519628771879236454097986825550D+ 1,+
     *0.482575722813320948395976669771D+ 1/
      DATA ABST( 91),ABST( 92),ABST( 93),ABST( 94),ABST( 95)/+
     *0.446401454693445890384147501245D+ 1,+
     *0.410970460356059023650054924395D+ 1,+
     *0.376172649022835778750118455640D+ 1,+
     *0.341916596936388461135547839398D+ 1,+
     *0.308124898864510584970840484975D+ 1/
      DATA ABST( 96),ABST( 97),ABST( 98),ABST( 99),ABST(100)/+
     *0.274730862482238321948145392074D+ 1,+
     *0.241676090487321645904643205900D+ 1,+
     *0.208908666094427643599567785405D+ 1,+
     *0.176381757989530000622984196672D+ 1,+
     *0.144052522013756518650995755277D+ 1/
      DATA ABST(101),ABST(102),ABST(103),ABST(104),ABST(105)/+
     *0.111881215240215656333400026648D+ 1,+
     *0.798304627778562231219097373434D  0,+
     *0.478646337594496098233148980979D  0,+
     *0.159492935848862470507111125726D  0,+
     *0.105261231679605458833268262838D+ 2/
      DATA ABST(106),ABST(107),ABST(108),ABST(109),ABST(110)/+
     *0.989528758682953902120446147715D+ 1,+
     *0.937315954964672116254565243972D+ 1,+
     *0.890724909996476975729597288564D+ 1,+
     *0.847752908337986309056416634482D+ 1,+
     *0.807368728501022522585879114075D+ 1/
      DATA ABST(111),ABST(112),ABST(113),ABST(114),ABST(115)/+
     *0.768954016404049682844780422986D+ 1,+
     *0.732101303278094920118956936371D+ 1,+
     *0.696524112055110752924264219349D+ 1,+
     *0.662011226263602737903666010893D+ 1,+
     *0.628401122877482823541809319507D+ 1/
      DATA ABST(116),ABST(117),ABST(118),ABST(119),ABST(120)/+
     *0.595566632679948604534456718098D+ 1,+
     *0.563405216434997214724992048330D+ 1,+
     *0.531832522463327085732364951519D+ 1,+
     *0.500777960219876819644370262718D+ 1,+
     *0.470181564740749981609753801581D+ 1/
      DATA ABST(121),ABST(122),ABST(123),ABST(124),ABST(125)/+
     *0.439991716822813764776793253543D+ 1,+
     *0.410163447456665671497098123845D+ 1,+
     *0.380657151394536046116597200046D+ 1,+
     *0.351437593574090621153995058647D+ 1,+
     *0.322473129199203572584817111018D+ 1/
      DATA ABST(126),ABST(127),ABST(128),ABST(129),ABST(130)/+
     *0.293735082300462180968533902619D+ 1,+
     *0.265197243543063501100545778599D+ 1,+
     *0.236835458863240140411151126534D+ 1,+
     *0.208627287988176202083256330236D+ 1,+
     *0.180551717146554491890377357418D+ 1/
      DATA ABST(131),ABST(132),ABST(133),ABST(134),ABST(135)/+
     *0.152588914020986366294897013315D+ 1,+
     *0.124720015694311794069356453069D+ 1,+
     *0.969269423071178016743541489019D  0,+
     *0.691922305810044577268219287595D  0,+
     *0.414988824121078684576929129199D  0/
      DATA ABST(136)/+0.138302244987009724115049767966D   0/
      DATA NSTOR(1), NSTOR(2), NSTOR(3), NSTOR(4) /1,2,3,4/
      DATA NSTOR(5), NSTOR(6), NSTOR(7), NSTOR(8) /5,6,8,10/
      DATA NSTOR(9), NSTOR(10), NSTOR(11), NSTOR(12) /12,14,16,20/
      DATA NSTOR(13), NSTOR(14), NSTOR(15), NSTOR(16) /24,32,48,64/
      DO I=1,NPTS
         WEIGHT(I) = 0.D0
         ABSCIS(I) = 0.D0
      ENDDO
      IF (B.GT.0.D0) GO TO 40
      IFAIL = 2
      RETURN
   40 N = 0
      NPTSA = 0
      IFAIL = 0
      DO I=1,16
         IF (NPTS.LT.NSTOR(I)) EXIT
         N = N + (NPTSA+1)/2
         NPTSA = NSTOR(I)
         IF (NPTS.EQ.NSTOR(I)) GO TO 100
      ENDDO
      IFAIL = 1
  100 ACON = A
      BCON = DSQRT(B)
      NL = NPTSA/2
      IF (NL.LT.1) GO TO 140
      DO NN=1,NL
         N = N + 1
         IIJJ = NPTSA + 1 - NN
         ABSCIS(NN) = ABST(N)/BCON + ACON
         WEIGHT(NN) = WTST(N)/BCON
         ABSCIS(IIJJ) = -ABST(N)/BCON +ACON
         WEIGHT(IIJJ) = WTST(N)/BCON
      ENDDO
  140 IF (NPTSA.LE.(NL+NL)) GO TO 160
      N = N + 1
      ABSCIS(NL+1) = ABST(N)/BCON + ACON
      WEIGHT(NL+1) = WTST(N)/BCON
  160 IF (ITYPE.EQ.1) RETURN
      EXPMIN = X02AEF(0.D0)
      DO N=1,NPTSA
         EXPNOW = -B*(ABSCIS(N)-A)**2 +DLOG(WEIGHT(N))
         IF (EXPNOW.LT.EXPMIN) GO TO 180
         WEIGHT(N) = DEXP(EXPNOW)
         CYCLE
  180    IFAIL = 3
         WEIGHT(N) = 0.D0
      ENDDO
      RETURN
      END
      SUBROUTINE D01BAX(A, B, ITYPE, NPTS, WEIGHT, ABSCIS, IFAIL)
C     MARK 7 RELEASE. NAG COPYRIGHT 1978.
C
C     RETURNS WEIGHTS AND PIVOTS FOR ONE GAUSS-LAGUERRE FORMULA IF
C     STORED
C     IFAIL = 1 - THE NPTS RULE IS NOT AMONG THOSE STORED
C     ( WEIGHT,ABSCIS EVALUATED FOR LARGEST VALID NPTS LESS THAN
C     REQUESTED VALUE)
C     IFAIL = 2 - B IS ZERO
C     ( ALL WEIGHTS AND ABSCISSAE RETURNED AS ZERO)
C     IFAIL = 3 - UNDERFLOW IN EVALUATING NORMAL WEIGHTS
C     ( THE UNDERFLOWING WEIGHTS ARE RETURNED AS ZERO)
C
C     THE WEIGHTS AND ABSCISSAE RETURNED DEPEND ON A AND B.
C     THOSE STORED ARE ADJUSTED WEIGHTSAND ABSCISSAE FOR A=0,B=1
C     THOSE RETURNED FOR GENERAL (A,B) ARE RELATED TO THOSE STORED
C     BY
C     X(A,B) = X(0,1) / B + A
C     W(A,B) = +W(0,1) / B        B>0  ADJUSTED WEIGHT
C     W(A,B) = +W(0,1) / B * EXP(-X(0,1)-B*A)   B>0    NORMAL WEIGHT
C     W(A,B) = -W(0,1) / B        B<0  ADJUSTED WEIGHT
C     W(A,B) = -W(0,1) / B * EXP(-X(0,1)-B*A)   B<0    NORMAL WEIGHT
C
C     .. SCALAR ARGUMENTS ..
      DOUBLE PRECISION A, B
      INTEGER IFAIL, ITYPE, NPTS
C     .. ARRAY ARGUMENTS ..
      DOUBLE PRECISION ABSCIS(NPTS), WEIGHT(NPTS)
C     ..
C     .. LOCAL SCALARS ..
      DOUBLE PRECISION EXPMIN, EXPNOW
      INTEGER I, N, NN, NPTSA
C     .. LOCAL ARRAYS ..
      DOUBLE PRECISION ABST(269), WTST(269)
      INTEGER NSTOR(16)
C     .. FUNCTION REFERENCES ..
      DOUBLE PRECISION DLOG, DEXP, X02AEF
C     ..
      DATA WTST( 1),WTST( 2),WTST( 3),WTST( 4),WTST( 5)/+
     *0.271828182845904523536028747135D  1,+
     *0.153332603311941684167312830146D  1,+
     *0.445095733505459280061001825091D  1,+
     *0.107769285927092079791596887249D  1,+
     *0.276214296190158724457379842928D  1/
      DATA WTST( 6),WTST( 7),WTST( 8),WTST( 9),WTST(10)/+
     *0.560109462543442626035941899059D  1,+
     *0.832739123837889246612084143083D  0,+
     *0.204810243845429682140044467983D  1,+
     *0.363114630582151786159635626368D  1,+
     *0.648714508440766227159534147675D  1/
      DATA WTST(11),WTST(12),WTST(13),WTST(14),WTST(15)/+
     *0.679094042207750455022104478403D  0,+
     *0.163848787360274721122549158591D  1,+
     *0.276944324237083809490196054399D  1,+
     *0.431565690092089471502857194927D  1,+
     *0.721918635435444832588471742846D  1/
      DATA WTST(16),WTST(17),WTST(18),WTST(19),WTST(20)/+
     *0.573535507422738094574234048232D  0,+
     *0.136925259071230452618549207458D  1,+
     *0.226068459338267234571450339803D  1,+
     *0.335052458235545672265573340326D  1,+
     *0.488682680021082495180621689077D  1/
      DATA WTST(21),WTST(22),WTST(23),WTST(24),WTST(25)/+
     *0.784901594559582139406265860711D  1,+
     *0.437723410492911373232597580123D  0,+
     *0.103386934766559764249926585582D  1,+
     *0.166970976565877574915392201770D  1,+
     *0.237692470175859948095916909947D  1/
      DATA WTST(26),WTST(27),WTST(28),WTST(29),WTST(30)/+
     *0.320854091334792628424839184576D  1,+
     *0.426857551082513219858412163065D  1,+
     *0.581808336867192192828814196198D  1,+
     *0.890622621529221140650104288102D  1,+
     *0.354009738606996308762226891442D  0/
      DATA WTST(31),WTST(32),WTST(33),WTST(34),WTST(35)/+
     *0.831902301043580738109829658127D  0,+
     *0.133028856174932817875279219439D  1,+
     *0.186306390311113098976398873548D  1,+
     *0.245025555808301016607269373165D  1,+
     *0.312276415513518249615081826331D  1/
      DATA WTST(36),WTST(37),WTST(38),WTST(39),WTST(40)/+
     *0.393415269556152109865581245924D  1,+
     *0.499241487219302310201148565243D  1,+
     *0.657220248513080297518766871037D  1,+
     *0.978469584037463069477008663871D  1,+
     *0.297209636044410797791981220367D  0/
      DATA WTST(41),WTST(42),WTST(43),WTST(44),WTST(45)/+
     *0.696462980430597230678066955855D  0,+
     *0.110778139461575215333946738014D  1,+
     *0.153846423904282912479403863350D  1,+
     *0.199832760627424276519696409653D  1,+
     *0.250074576910086687475087066330D  1/
      DATA WTST(46),WTST(47),WTST(48),WTST(49),WTST(50)/+
     *0.306532151828238623620460341805D  1,+
     *0.372328911078277159999560977971D  1,+
     *0.452981402998173506209331191236D  1,+
     *0.559725846183532109269052390850D  1,+
     *0.721299546092587700817113516652D  1/
      DATA WTST(51),WTST(52),WTST(53),WTST(54),WTST(55)/+
     *0.105438374619100811117158467701D  2,+
     *0.256131154736909453671556041372D  0,+
     *0.599170477495118338515766272071D  0,+
     *0.949971502474957986912548427093D  0,+
     *0.131280781146616393842708842484D  1/
      DATA WTST(56),WTST(57),WTST(58),WTST(59),WTST(60)/+
     *0.169326599075196535297454106764D  1,+
     *0.209840908427184368777350257727D  1,+
     *0.253763265493539384488200996575D  1,+
     *0.302415991770323993864679517162D  1,+
     *0.357780435571985991642606879222D  1/
      DATA WTST(61),WTST(62),WTST(63),WTST(64),WTST(65)/+
     *0.423056503490643204894994893849D  1,+
     *0.503941336846351161882976936647D  1,+
     *0.612094792832972552370440564980D  1,+
     *0.777429536700603211748936983427D  1,+
     *0.112168342167033196897235541569D  2/
      DATA WTST(66),WTST(67),WTST(68),WTST(69),WTST(70)/+
     *0.225036314864247251906600757381D  0,+
     *0.525836052762342453614569410519D  0,+
     *0.831961391687087087665388515060D  0,+
     *0.114609924096375170464795693025D  1,+
     *0.147175131696680858874304204586D  1/
      DATA WTST( 71),WTST( 72),WTST( 73),WTST( 74),WTST( 75)/+
     *0.181313468738134816488739610863D  1,+
     *0.217551751969460745206267083222D  1,+
     *0.256576275016502920924861688456D  1,+
     *0.299321508637137516517802515156D  1,+
     *0.347123448310209029087386862759D  1/
      DATA WTST( 76),WTST( 77),WTST( 78),WTST( 79),WTST( 80)/+
     *0.402004408644466886647828411535D  1,+
     *0.467251660773285426736570925651D  1,+
     *0.548742065798615247120752800022D  1,+
     *0.658536123328921366083470226903D  1,+
     *0.827635798436423448649507548525D  1/
      DATA WTST( 81),WTST( 82),WTST( 83),WTST( 84),WTST( 85)/+
     *0.118242775516584347866877735109D  2,+
     *0.181080062418989255451675405913D  0,+
     *0.422556767878563974520344172566D  0,+
     *0.666909546701848150373482114992D  0,+
     *0.915352372783073672670604684771D  0/
      DATA WTST( 86),WTST( 87),WTST( 88),WTST( 89),WTST( 90)/+
     *0.116953970719554597380147822239D  1,+
     *0.143135498592820598636844994891D  1,+
     *0.170298113798502272402533261633D  1,+
     *0.198701589079274721410921839275D  1,+
     *0.228663578125343078546222854681D  1/
      DATA WTST( 91),WTST( 92),WTST( 93),WTST( 94),WTST( 95)/+
     *0.260583472755383333269498950954D  1,+
     *0.294978373421395086600235416827D  1,+
     *0.332539578200931955236951937421D  1,+
     *0.374225547058981092111707293265D  1,+
     *0.421423671025188041986808063782D  1/
      DATA WTST( 96),WTST( 97),WTST( 98),WTST( 99),WTST(100)/+
     *0.476251846149020929695292197839D  1,+
     *0.542172604424557430380308297989D  1,+
     *0.625401235693242129289518490300D  1,+
     *0.738731438905443455194030019196D  1,+
     *0.915132873098747960794348242552D  1/
      DATA WTST(101),WTST(102),WTST(103),WTST(104),WTST(105)/+
     *0.128933886459399966710262871287D  2,+
     *0.151494412859509452265084493232D  0,+
     *0.353256582529923846700037134831D  0,+
     *0.556784563288152601393983130602D  0,+
     *0.762685317697309109177545772892D  0/
      DATA WTST(106),WTST(107),WTST(108),WTST(109),WTST(110)/+
     *0.971872632246547580059256369503D  0,+
     *0.118535789303780108804108500052D  1,+
     *0.140426562728441853150972524948D  1,+
     *0.162986861575704148558270248151D  1,+
     *0.186363505533207295181759526057D  1/
      DATA WTST(111),WTST(112),WTST(113),WTST(114),WTST(115)/+
     *0.210729115108148019370959984474D  1,+
     *0.236290589104193499858881524405D  1,+
     *0.263300875316385674795069380502D  1,+
     *0.292075757972772466982359777403D  1,+
     *0.323018513349235362651935975293D  1/
      DATA WTST(116),WTST(117),WTST(118),WTST(119),WTST(120)/+
     *0.356657337736875656898291635370D  1,+
     *0.393704375545516029872135252120D  1,+
     *0.435153118886351196927787610512D  1,+
     *0.482448185489803577155380384940D  1,+
     *0.537802207978918232457718195130D  1/
      DATA WTST(121),WTST(122),WTST(123),WTST(124),WTST(125)/+
     *0.604841781261996523358721632126D  1,+
     *0.690089835218049651660271292953D  1,+
     *0.806996515614695609996392008808D  1,+
     *0.990279331948422547854446022889D  1,+
     *0.138205320947920056947750939475D  2/
      DATA WTST(126),WTST(127),WTST(128),WTST(129),WTST(130)/+
     *0.114187105768104848927622124462D  0,+
     *0.266065216897615216046611346939D  0,+
     *0.418793137324852994249899207384D  0,+
     *0.572532846499804706459178417281D  0,+
     *0.727648788380971310663061585107D  0/
      DATA WTST(131),WTST(132),WTST(133),WTST(134),WTST(135)/+
     *0.884536719340249717425872878285D  0,+
     *0.104361887589207696731026388350D  1,+
     *0.120534927415235258024261192627D  1,+
     *0.137022133852178118598605841546D  1,+
     *0.153877725646864475240238323237D  1/
      DATA WTST(136),WTST(137),WTST(138),WTST(139),WTST(140)/+
     *0.171161935268645725598271887040D  1,+
     *0.188942406344948409803711219836D  1,+
     *0.207295934024653366947196417576D  1,+
     *0.226310663399696361289684222133D  1,+
     *0.246088907248823612862689024688D  1/
      DATA WTST(141),WTST(142),WTST(143),WTST(144),WTST(145)/+
     *0.266750812639711714721138456555D  1,+
     *0.288439209292204179062593430341D  1,+
     *0.311326132703958617632792149348D  1,+
     *0.335621769259580255854557831643D  1,+
     *0.361586985648426880697848391718D  1/
      DATA WTST(146),WTST(147),WTST(148),WTST(149),WTST(150)/+
     *0.389551304494854956387911255376D  1,+
     *0.419939410471158549451926456093D  1,+
     *0.453311497853436176838674105540D  1,+
     *0.490427028761124484381895572477D  1,+
     *0.532350097202366611244575679955D  1/
      DATA WTST(151),WTST(152),WTST(153),WTST(154),WTST(155)/+
     *0.580633321423362136100029944855D  1,+
     *0.637661467415965254382865981278D  1,+
     *0.707352658070724212022493611301D  1,+
     *0.796769350929590065853696429051D  1,+
     *0.920504033127818957827330325406D  1/
      DATA WTST(156),WTST(157),WTST(158),WTST(159),WTST(160)/+
     *0.111630130907678730889083422741D  2,+
     *0.153901804152606431051579823628D  2,+
     *0.765091770514956761342118898575D -1,+
     *0.178176753775905398828330884895D  0,+
     *0.280182139884356357596595727330D  0/
      DATA WTST(161),WTST(162),WTST(163),WTST(164),WTST(165)/+
     *0.382496359087169141718115527434D  0,+
     *0.485219064838925983329963727664D  0,+
     *0.588460905319131679496727354214D  0,+
     *0.692336967999966138193085613549D  0,+
     *0.796966494376616045970268027815D  0/
      DATA WTST(166),WTST(167),WTST(168),WTST(169),WTST(170)/+
     *0.902473457882823144220145784820D  0,+
     *0.100898737232707629800542126981D  1,+
     *0.111664422803075856160612314698D  1,+
     *0.122558754531793799662824812056D  1,+
     *0.133596955840331729647271660268D  1/
      DATA WTST(171),WTST(172),WTST(173),WTST(174),WTST(175)/+
     *0.144795255226199847441425272802D  1,+
     *0.156171038186323193269790621716D  1,+
     *0.167743021013445771532736944822D  1,+
     *0.179531450931003985792738517152D  1,+
     *0.191558338064478820192149989162D  1/
      DATA WTST(176),WTST(177),WTST(178),WTST(179),WTST(180)/+
     *0.203847726058527662650086185673D  1,+
     *0.216426009832609346748191008287D  1,+
     *0.229322311147943740839172475438D  1,+
     *0.242568925506195650730249226019D  1,+
     *0.256201857652746411478348320242D  1/
      DATA WTST(181),WTST(182),WTST(183),WTST(184),WTST(185)/+
     *0.270261467949469543001506372612D  1,+
     *0.284793258591011472410303079716D  1,+
     *0.299848837754813525039891195619D  1,+
     *0.315487112309995635064677782804D  1,+
     *0.331775777168698824008904633906D  1/
      DATA WTST(186),WTST(187),WTST(188),WTST(189),WTST(190)/+
     *0.348793194021297842501060920895D  1,+
     *0.366630787556595224979178358464D  1,+
     *0.385396138825025874303713182147D  1,+
     *0.405217031962381213209747661016D  1,+
     *0.426246826493193786394704415086D  1/
      DATA WTST(191),WTST(192),WTST(193),WTST(194),WTST(195)/+
     *0.448671707169671091589039881160D  1,+
     *0.472720648823902161949013908500D  1,+
     *0.498679400159401977932888513142D  1,+
     *0.526910576963126839774948155580D  1,+
     *0.557883330406359379212374112554D  1/
      DATA WTST(196),WTST(197),WTST(198),WTST(199),WTST(200)/+
     *0.592218562814899595664471636459D  1,+
     *0.630760460370205282500468664054D  1,+
     *0.674694836479823449434242742733D  1,+
     *0.725755907386616981074413594121D  1,+
     *0.786613116690562813520995457417D  1/
      DATA WTST(201),WTST(202),WTST(203),WTST(204),WTST(205)/+
     *0.861661439476592280229011734260D  1,+
     *0.958839324881700067247977716658D  1,+
     *0.109458446112439663157067260588D  2,+
     *0.131151217146602229005940242378D  2,+
     *0.178491385116857843412986990778D  2/
      DATA WTST(206),WTST(207),WTST(208),WTST(209),WTST(210)/+
     *0.575280378894525890436272546419D -1,+
     *0.133947450012544835069889920242D  0,+
     *0.210559520190062753410264651011D  0,+
     *0.287306741593137458969672041580D  0,+
     *0.364227443636669253424976184947D  0/
      DATA WTST(211),WTST(212),WTST(213),WTST(214),WTST(215)/+
     *0.441366991509961979889210808772D  0,+
     *0.518772490744390800682370587402D  0,+
     *0.596492178616888933402265930722D  0,+
     *0.674575428995967007360981705790D  0,+
     *0.753072886217714028284601274000D  0/
      DATA WTST(216),WTST(217),WTST(218),WTST(219),WTST(220)/+
     *0.832036640613840971591650743949D  0,+
     *0.911520426089580266925697685845D  0,+
     *0.991579835527047789201975349412D  0,+
     *0.107227255416963941372856442434D  1,+
     *0.115365861273396411749745147603D  1/
      DATA WTST(221),WTST(222),WTST(223),WTST(224),WTST(225)/+
     *0.123580066279341248881853914308D  1,+
     *0.131876427755265408207115394964D  1,+
     *0.140261828167573410750385225619D  1,+
     *0.148743511441922552285890599395D  1,+
     *0.157329123099770495428549561253D  1/
      DATA WTST(226),WTST(227),WTST(228),WTST(229),WTST(230)/+
     *0.166026754790322603808659025443D  1,+
     *0.174844993884468966840811618879D  1,+
     *0.183792978910258781922516500950D  1,+
     *0.192880461745247173533359506744D  1,+
     *0.202117877644994616093176453417D  1/
      DATA WTST(231),WTST(232),WTST(233),WTST(234),WTST(235)/+
     *0.211516424385799162624719639754D  1,+
     *0.221088152041886537611449023992D  1,+
     *0.230846065213609279982632607119D  1,+
     *0.240804239887634595140989226663D  1,+
     *0.250977957560631372032781037131D  1/
      DATA WTST(236),WTST(237),WTST(238),WTST(239),WTST(240)/+
     *0.261383859818030413164098194230D  1,+
     *0.272040127259742280397253628212D  1,+
     *0.282966687545834169553812193088D  1,+
     *0.294185458451072051222172729948D  1,+
     *0.305720633240365251994286550241D  1/
      DATA WTST(241),WTST(242),WTST(243),WTST(244),WTST(245)/+
     *0.317599017505567106136883642108D  1,+
     *0.329850428971767201180649338506D  1,+
     *0.342508174873032369478537875834D  1,+
     *0.355609625571314495229008688830D  1,+
     *0.369196908511496649021136048390D  1/
      DATA WTST(246),WTST(247),WTST(248),WTST(249),WTST(250)/+
     *0.383317753889189122064583790377D  1,+
     *0.398026533306148232515021866253D  1,+
     *0.413385546300965414284704119140D  1,+
     *0.429466628606838520049412599557D  1,+
     *0.446353182779689666078949512940D  1/
      DATA WTST(251),WTST(252),WTST(253),WTST(254),WTST(255)/+
     *0.464142770270254264085828787326D  1,+
     *0.482950460064931503418077262552D  1,+
     *0.502913212279840979430654758303D  1,+
     *0.524195701287730126627980161538D  1,+
     *0.546998178554909056209921349058D  1/
      DATA WTST(256),WTST(257),WTST(258),WTST(259),WTST(260)/+
     *0.571567286191836668397881349597D  1,+
     *0.598211240191709826717503888173D  1,+
     *0.627321659221683862023469019562D  1,+
     *0.659405813561881627268928484176D  1,+
     *0.695135801769598999598967976377D  1/
      DATA WTST(261),WTST(262),WTST(263),WTST(264),WTST(265)/+
     *0.735426394860807842222542512048D  1,+
     *0.781563898596646341332894443685D  1,+
     *0.835431448453341961926802062004D  1,+
     *0.899930753225570263393059351411D  1,+
     *0.979844329910944665303288441737D  1/
      DATA WTST(266),WTST(267),WTST(268),WTST(269)/+
     *0.108382034590564480648538159816D  2,+
     *0.122978755043572691690380934991D  2,+
     *0.146428784968432459176822293531D  2,+
     *0.197904730417376936028236124789D  2/
      DATA ABST( 1),ABST( 2),ABST( 3),ABST( 4),ABST( 5)/+
     *0.100000000000000000000000000000D  1,+
     *0.585786437626904951198311275790D  0,+
     *0.341421356237309504880168872420D+ 1,+
     *0.415774556783479083311533873128D  0,+
     *0.229428036027904171982205036135D+ 1/
      DATA ABST( 6),ABST( 7),ABST( 8),ABST( 9),ABST(10)/+
     *0.628994508293747919686641576551D+ 1,+
     *0.322547689619392311800361459104D  0,+
     *0.174576110115834657568681671251D+ 1,+
     *0.453662029692112798327928538495D+ 1,+
     *0.939507091230113312923353644342D+ 1/
      DATA ABST(11),ABST(12),ABST(13),ABST(14),ABST(15)/+
     *0.263560319718140910203061943360D  0,+
     *0.141340305910651679221840798018D+ 1,+
     *0.359642577104072208122318658878D+ 1,+
     *0.708581000585883755692212418110D+ 1,+
     *0.126408008442757826594332193065D+ 2/
      DATA ABST(16),ABST(17),ABST(18),ABST(19),ABST(20)/+
     *0.222846604179260689464354826786D  0,+
     *0.118893210167262303074315092193D+ 1,+
     *0.299273632605931407769132528451D+ 1,+
     *0.577514356910451050183983036943D+ 1,+
     *0.983746741838258991771554702994D+ 1/
      DATA ABST(21),ABST(22),ABST(23),ABST(24),ABST(25)/+
     *0.159828739806017017825457915673D+ 2,+
     *0.170279632305100999788861856608D  0,+
     *0.903701776799379912186020223555D  0,+
     *0.225108662986613068930711836696D+ 1,+
     *0.426670017028765879364942182690D+ 1/
      DATA ABST(26),ABST(27),ABST(28),ABST(29),ABST(30)/+
     *0.704590540239346569727932548211D+ 1,+
     *0.107585160101809952240599567880D+ 2,+
     *0.157406786412780045780287611584D+ 2,+
     *0.228631317368892641057005342974D+ 2,+
     *0.137793470540492430830772505652D  0/
      DATA ABST(31),ABST(32),ABST(33),ABST(34),ABST(35)/+
     *0.729454549503170498160373121676D  0,+
     *0.180834290174031604823292007575D+ 1,+
     *0.340143369785489951448253222140D+ 1,+
     *0.555249614006380363241755848686D+ 1,+
     *0.833015274676449670023876719727D+ 1/
      DATA ABST(36),ABST(37),ABST(38),ABST(39),ABST(40)/+
     *0.118437858379000655649185389191D+ 2,+
     *0.162792578313781020995326539358D+ 2,+
     *0.219965858119807619512770901955D+ 2,+
     *0.299206970122738915599087933407D+ 2,+
     *0.115722117358020675267196428240D  0/
      DATA ABST(41),ABST(42),ABST(43),ABST(44),ABST(45)/+
     *0.611757484515130665391630053041D  0,+
     *0.151261026977641878678173792686D+ 1,+
     *0.283375133774350722862747177657D+ 1,+
     *0.459922763941834848460572922485D+ 1,+
     *0.684452545311517734775433041849D+ 1/
      DATA ABST(46),ABST(47),ABST(48),ABST(49),ABST(50)/+
     *0.962131684245686704391238234923D+ 1,+
     *0.130060549933063477203460524294D+ 2,+
     *0.171168551874622557281840528007D+ 2,+
     *0.221510903793970056699218950836D+ 2,+
     *0.284879672509840003125686072325D+ 2/
      DATA ABST(51),ABST(52),ABST(53),ABST(54),ABST(55)/+
     *0.370991210444669203366389142763D+ 2,+
     *0.997475070325975745736829452514D -1,+
     *0.526857648851902896404583451502D  0,+
     *0.130062912125149648170842022115D+ 1,+
     *0.243080107873084463616999751038D+ 1/
      DATA ABST(56),ABST(57),ABST(58),ABST(59),ABST(60)/+
     *0.393210282229321888213134366777D+ 1,+
     *0.582553621830170841933899983898D+ 1,+
     *0.814024014156514503005978046052D+ 1,+
     *0.109164995073660188408130510904D+ 2,+
     *0.142108050111612886831059780825D+ 2/
      DATA ABST(61),ABST(62),ABST(63),ABST(64),ABST(65)/+
     *0.181048922202180984125546272082D+ 2,+
     *0.227233816282696248232280886984D+ 2,+
     *0.282729817232482056954158923217D+ 2,+
     *0.351494436605924265828643121363D+ 2,+
     *0.443660817111174230416312423665D+ 2/
      DATA ABST(66),ABST(67),ABST(68),ABST(69),ABST(70)/+
     *0.876494104789278403601980973401D -1,+
     *0.462696328915080831880838260664D  0,+
     *0.114105777483122685687794501810D+ 1,+
     *0.212928364509838061632615907065D+ 1,+
     *0.343708663389320664523510701675D+ 1/
      DATA ABST( 71),ABST( 72),ABST( 73),ABST( 74),ABST( 75)/+
     *0.507801861454976791292305830814D+ 1,+
     *0.707033853504823413039598947080D+ 1,+
     *0.943831433639193878394724672911D+ 1,+
     *0.122142233688661587369391246088D+ 2,+
     *0.154415273687816170767647741622D+ 2/
      DATA ABST( 76),ABST( 77),ABST( 78),ABST( 79),ABST( 80)/+
     *0.191801568567531348546631409497D+ 2,+
     *0.235159056939919085318231872751D+ 2,+
     *0.285787297428821403675206137098D+ 2,+
     *0.345833987022866258145276871777D+ 2,+
     *0.419404526476883326354722330251D+ 2/
      DATA ABST( 81),ABST( 82),ABST( 83),ABST( 84),ABST( 85)/+
     *0.517011603395433183643426971196D+ 2,+
     *0.705398896919887533666890045842D -1,+
     *0.372126818001611443794241388761D  0,+
     *0.916582102483273564667716277074D  0,+
     *0.170730653102834388068768966741D+ 1/
      DATA ABST( 86),ABST( 87),ABST( 88),ABST( 89),ABST( 90)/+
     *0.274919925530943212964503046049D+ 1,+
     *0.404892531385088692237495336913D+ 1,+
     *0.561517497086161651410453988565D+ 1,+
     *0.745901745367106330976886021837D+ 1,+
     *0.959439286958109677247367273428D+ 1/
      DATA ABST( 91),ABST( 92),ABST( 93),ABST( 94),ABST( 95)/+
     *0.120388025469643163096234092988D+ 2,+
     *0.148142934426307399785126797100D+ 2,+
     *0.179488955205193760173657909926D+ 2,+
     *0.214787882402850109757351703695D+ 2,+
     *0.254517027931869055035186774846D+ 2/
      DATA ABST( 96),ABST( 97),ABST( 98),ABST( 99),ABST(100)/+
     *0.299325546317006120067136561351D+ 2,+
     *0.350134342404790000062849359066D+ 2,+
     *0.408330570567285710620295677078D+ 2,+
     *0.476199940473465021399416271528D+ 2,+
     *0.558107957500638988907507734444D+ 2/
      DATA ABST(101),ABST(102),ABST(103),ABST(104),ABST(105)/+
     *0.665244165256157538186403187914D+ 2,+
     *0.590198521815079769729796536122D -1,+
     *0.311239146198483726857006190420D  0,+
     *0.766096905545936646238779533956D  0,+
     *0.142559759080361308631349091388D+ 1/
      DATA ABST(106),ABST(107),ABST(108),ABST(109),ABST(110)/+
     *0.229256205863219029495204873720D+ 1,+
     *0.337077426420899771619826348266D+ 1,+
     *0.466508370346717079205845386989D+ 1,+
     *0.618153511873676541184349133097D+ 1,+
     *0.792753924717215217938007631016D+ 1/
      DATA ABST(111),ABST(112),ABST(113),ABST(114),ABST(115)/+
     *0.991209801507770601882725231142D+ 1,+
     *0.121461027117297655500645484691D+ 2,+
     *0.146427322895966743422854804679D+ 2,+
     *0.174179926465089787263183235716D+ 2,+
     *0.204914600826164247068259432350D+ 2/
      DATA ABST(116),ABST(117),ABST(118),ABST(119),ABST(120)/+
     *0.238873298481697331753233786780D+ 2,+
     *0.276359371743327174202705297948D+ 2,+
     *0.317760413523747232883580042751D+ 2,+
     *0.363584058016516216531070205907D+ 2,+
     *0.414517204848707670507153988602D+ 2/
      DATA ABST(121),ABST(122),ABST(123),ABST(124),ABST(125)/+
     *0.471531064451563230413708267956D+ 2,+
     *0.536085745446950698237910753558D+ 2,+
     *0.610585314472187615638081429898D+ 2,+
     *0.699622400351050304314877818947D+ 2,+
     *0.814982792339488853766317026866D+ 2/
      DATA ABST(126),ABST(127),ABST(128),ABST(129),ABST(130)/+
     *0.444893658332670184188501945243D -1,+
     *0.234526109519618537452909561301D  0,+
     *0.576884629301886426491552569377D  0,+
     *0.107244875381781763304091397717D+ 1,+
     *0.172240877644464544113093292797D+ 1/
      DATA ABST(131),ABST(132),ABST(133),ABST(134),ABST(135)/+
     *0.252833670642579488112419990555D+ 1,+
     *0.349221327302199448960880339977D+ 1,+
     *0.461645676974976738776205229617D+ 1,+
     *0.590395850417424394656152149158D+ 1,+
     *0.735812673318624111322198973719D+ 1/
      DATA ABST(136),ABST(137),ABST(138),ABST(139),ABST(140)/+
     *0.898294092421259610337824752676D+ 1,+
     *0.107830186325399720675019491380D+ 2,+
     *0.127636979867427251149690330822D+ 2,+
     *0.149311397555225573197969646873D+ 2,+
     *0.172924543367153147892357183836D+ 2/
      DATA ABST(141),ABST(142),ABST(143),ABST(144),ABST(145)/+
     *0.198558609403360547397899445841D+ 2,+
     *0.226308890131967744886757793393D+ 2,+
     *0.256286360224592477674761768768D+ 2,+
     *0.288621018163234747443426407115D+ 2,+
     *0.323466291539647370032321654236D+ 2/
      DATA ABST(146),ABST(147),ABST(148),ABST(149),ABST(150)/+
     *0.361004948057519738040171189479D+ 2,+
     *0.401457197715394415362093439289D+ 2,+
     *0.445092079957549379759066043775D+ 2,+
     *0.492243949873086391767222218065D+ 2,+
     *0.543337213333969073328671815511D+ 2/
      DATA ABST(151),ABST(152),ABST(153),ABST(154),ABST(155)/+
     *0.598925091621340181961304753246D+ 2,+
     *0.659753772879350527965630761193D+ 2,+
     *0.726876280906627086386753490877D+ 2,+
     *0.801874469779135230674916385686D+ 2,+
     *0.887353404178923986893554495242D+ 2/
      DATA ABST(156),ABST(157),ABST(158),ABST(159),ABST(160)/+
     *0.988295428682839725591844784095D+ 2,+
     *0.111751398097937695213664716539D+ 3,+
     *0.298112358299601106829853667398D -1,+
     *0.157107990617876302228195178939D  0,+
     *0.386265037576455586428816629438D  0/
      DATA ABST(161),ABST(162),ABST(163),ABST(164),ABST(165)/+
     *0.717574694116972254573576608055D  0,+
     *0.115139383402643463980184566755D+ 1,+
     *0.168818582341904720592285004127D+ 1,+
     *0.232852700665322873332764798204D+ 1,+
     *0.307311086165263883575281517844D+ 1/
      DATA ABST(166),ABST(167),ABST(168),ABST(169),ABST(170)/+
     *0.392275241304648049404373262669D+ 1,+
     *0.487839335592134610923895222351D+ 1,+
     *0.594110805462455896865557843817D+ 1,+
     *0.711211053589074335395756436908D+ 1,+
     *0.839276259909122462543275584035D+ 1/
      DATA ABST(171),ABST(172),ABST(173),ABST(174),ABST(175)/+
     *0.978458318468732328311039934253D+ 1,+
     *0.112892591680095271459189553326D+ 2,+
     *0.129086577782855308951121527464D+ 2,+
     *0.146448408832097058214254190541D+ 2,+
     *0.165000814289645861331718007023D+ 2/
      DATA ABST(176),ABST(177),ABST(178),ABST(179),ABST(180)/+
     *0.184768823868741128170595461291D+ 2,+
     *0.205779986340222095048549228477D+ 2,+
     *0.228064622905213716617755943301D+ 2,+
     *0.251656121564391080064746932077D+ 2,+
     *0.276591280444805295952522961805D+ 2/
      DATA ABST(181),ABST(182),ABST(183),ABST(184),ABST(185)/+
     *0.302910710010085672389940239882D+ 2,+
     *0.330659306624987441669455760390D+ 2,+
     *0.359886813274789357829330330344D+ 2,+
     *0.390648487641977701833743857277D+ 2,+
     *0.423005903629030935825241353591D+ 2/
      DATA ABST(186),ABST(187),ABST(188),ABST(189),ABST(190)/+
     *0.457027920385114703676741052240D+ 2,+
     *0.492791863828367928598558836374D+ 2,+
     *0.530384980878166647263784462888D+ 2,+
     *0.569906248148044758260119738032D+ 2,+
     *0.611468647861402287499987744077D+ 2/
      DATA ABST(191),ABST(192),ABST(193),ABST(194),ABST(195)/+
     *0.655202069290186065213469036256D+ 2,+
     *0.701257062361131915516608967787D+ 2,+
     *0.749809775189113105914056728904D+ 2,+
     *0.801068573503243938016002357403D+ 2,+
     *0.855283111160341678871016141692D+ 2/
      DATA ABST(196),ABST(197),ABST(198),ABST(199),ABST(200)/+
     *0.912757079936680894506618458847D+ 2,+
     *0.973866677135815318301368770382D+ 2,+
     *0.103908833357176254669020231842D+ 3,+
     *0.110904220884976275490415573534D+ 3,+
     *0.118456425046283632024607258015D+ 3/
      DATA ABST(201),ABST(202),ABST(203),ABST(204),ABST(205)/+
     *0.126683425768885830929664830625D+ 3,+
     *0.135762589577864301973383740811D+ 3,+
     *0.145986432709463454689492988746D+ 3,+
     *0.157915612022977989521785821968D+ 3,+
     *0.172996328148563253498822074794D+ 3/
      DATA ABST(206),ABST(207),ABST(208),ABST(209),ABST(210)/+
     *0.224158741467052800228118848190D -1,+
     *0.118122512096770479797466436710D  0,+
     *0.290365744018036483999130066385D  0,+
     *0.539286221227979039318144947812D  0,+
     *0.865037004648113944619955074709D  0/
      DATA ABST(211),ABST(212),ABST(213),ABST(214),ABST(215)/+
     *0.126781404077524139811570887769D+ 1,+
     *0.174785962605943625282996395128D+ 1,+
     *0.230546373930750871854807054389D+ 1,+
     *0.294096515672525184067946815210D+ 1,+
     *0.365475265020729052703539791209D+ 1/
      DATA ABST(216),ABST(217),ABST(218),ABST(219),ABST(220)/+
     *0.444726634331309435674255098016D+ 1,+
     *0.531899925449639034352210985918D+ 1,+
     *0.627049904692365391291106464633D+ 1,+
     *0.730237000258739574722349840951D+ 1,+
     *0.841527523948302419449521859120D+ 1/
      DATA ABST(221),ABST(222),ABST(223),ABST(224),ABST(225)/+
     *0.960993919279610803576288204954D+ 1,+
     *0.108871503838863721425945504201D+ 2,+
     *0.122477645042443016181623692907D+ 2,+
     *0.136927078455475051527299325746D+ 2,+
     *0.152229811115247288480082687834D+ 2/
      DATA ABST(226),ABST(227),ABST(228),ABST(229),ABST(230)/+
     *0.168396636526487372105288380391D+ 2,+
     *0.185439181708591905236196259710D+ 2,+
     *0.203369959487302355011498158064D+ 2,+
     *0.222202426659508765399221543470D+ 2,+
     *0.241951048759332539898864438802D+ 2/
      DATA ABST(231),ABST(232),ABST(233),ABST(234),ABST(235)/+
     *0.262631372271184857851260239547D+ 2,+
     *0.284260105275010272994997715267D+ 2,+
     *0.306855207675259717710485823984D+ 2,+
     *0.330435992364378291255202106805D+ 2,+
     *0.355023238911412095869787785350D+ 2/
      DATA ABST(236),ABST(237),ABST(238),ABST(239),ABST(240)/+
     *0.380639321656464682603573179150D+ 2,+
     *0.407308354444586263657318695132D+ 2,+
     *0.435056354664215298527031849317D+ 2,+
     *0.463911429786161920736053999423D+ 2,+
     *0.493903990256246866792358008226D+ 2/
      DATA ABST(241),ABST(242),ABST(243),ABST(244),ABST(245)/+
     *0.525066993413463016501792769804D+ 2,+
     *0.557436224132783804633357112911D+ 2,+
     *0.591050619190171066088487420918D+ 2,+
     *0.625952644001513955960550179011D+ 2,+
     *0.662188732512475643822137626710D+ 2/
      DATA ABST(246),ABST(247),ABST(248),ABST(249),ABST(250)/+
     *0.699809803771468292285346579722D+ 2,+
     *0.738871872324829632109574031135D+ 2,+
     *0.779436774344631203136879758705D+ 2,+
     *0.821573037783193042951958683422D+ 2,+
     *0.865356933494565182102162783752D+ 2/
      DATA ABST(251),ABST(252),ABST(253),ABST(254),ABST(255)/+
     *0.910873756131330901456367153492D+ 2,+
     *0.958219400155207320947672154364D+ 2,+
     *0.100750231969513979629259261451D+ 3,+
     *0.105884599468799949356360427850D+ 3,+
     *0.111239207524439582063484736637D+ 3/
      DATA ABST(256),ABST(257),ABST(258),ABST(259),ABST(260)/+
     *0.116830445051306498463386669077D+ 3,+
     *0.122677460268538576577419690564D+ 3,+
     *0.128802878769237672512753623054D+ 3,+
     *0.135233787949525827833980498878D+ 3,+
     *0.142003121489931519025140038291D+ 3/
      DATA ABST(261),ABST(262),ABST(263),ABST(264),ABST(265)/+
     *0.149151665900049388587293462932D+ 3,+
     *0.156731075132671161233616960813D+ 3,+
     *0.164808602655150522993190109025D+ 3,+
     *0.173474946836424274522152844866D+ 3,+
     *0.182858204691431463646342794509D+ 3/
      DATA ABST(266),ABST(267),ABST(268),ABST(269)/+
     *0.193151136037072911479385527417D+ 3,+
     *0.204672028485059455949064433342D+ 3,+
     *0.218031851935328516332452384448D+ 3,+
     *0.234809579171326164713055529725D+ 3/
      DATA NSTOR(1), NSTOR(2), NSTOR(3), NSTOR(4) /1,2,3,4/
      DATA NSTOR(5), NSTOR(6), NSTOR(7), NSTOR(8) /5,6,8,10/
      DATA NSTOR(9), NSTOR(10), NSTOR(11), NSTOR(12) /12,14,16,20/
      DATA NSTOR(13), NSTOR(14), NSTOR(15), NSTOR(16) /24,32,48,64/
      DO I=1,NPTS
         WEIGHT(I) = 0.D0
         ABSCIS(I) = 0.D0
      ENDDO
      IF (B.NE.0.D0) GO TO 40
      IFAIL = 2
      RETURN
   40 N = 0
      NPTSA = 0
      IFAIL = 0
      !stop 'before return d01bax'
      DO I=1,16
         IF (NPTS.LT.NSTOR(I)) EXIT
         N = N + NPTSA
         NPTSA = NSTOR(I)
         IF (NPTS.EQ.NSTOR(I)) GO TO 100
      ENDDO
      IFAIL = 1
  100 DO NN=1,NPTSA
         N = N + 1
         ABSCIS(NN) = ABST(N)/B + A
         WEIGHT(NN) = WTST(N)/B
         IF (B.LT.0.D0) WEIGHT(NN) = -WEIGHT(NN)
      ENDDO
      IF (ITYPE.EQ.1) RETURN
      EXPMIN = X02AEF(0.D0)
      DO N=1,NPTSA
         EXPNOW = -B*ABSCIS(N) + DLOG(WEIGHT(N))
         IF (EXPNOW.LT.EXPMIN) GO TO 140
         WEIGHT(N) = DEXP(EXPNOW)
         CYCLE
  140    IFAIL = 3
         WEIGHT(N) = 0.D0
      ENDDO
      RETURN
      END
      SUBROUTINE D01BAY(A, B, ITYPE, NPTS, WEIGHT, ABSCIS, IFAIL)
C     MARK 7 RELEASE. NAG COPYRIGHT 1978.
C
C     RETURNS WEIGHTS AND PIVOTS FOR ONE GAUSS-RATIONAL FORMULA IF
C     STORED
C     IFAIL = 1 - THE NPTS RULE IS NOT AMONG THOSE STORED
C     ( WEIGHT,ABSCIS EVALUATED FOR LARGEST VALID NPTS LESS THAN
C     REQUESTED VALUE)
C     IFAIL = 2 - A + B = 0
C     ( ALL WEIGHTS AND ABSCISSAE RETURNED AS ZERO)
C
C     THE WEIGHTS AND ABSCISSAE RETURNED DEPEND ON A AND B.
C     THOSE FOR A=0,B=1 ARE RELATED TO THE GAUSS-LEGENDRE WEIGHTS
C     BY
C     W(0,1) = +2 * WGL(-1,+1) / (XGL(-1,+1) + 1)**2
C     X(0,1) = +2 / (XGL(-1,+1) + 1) - 1
C     THOSE FOR GENERAL (A,B) ARE RELATED TO THOSE FOR (0,1) BY
C     W(A,B) = +W(0,1) * (A+B)        FOR A+B > 0
C     W(A,B) = -W(0,1) * (A+B)        FOR A+B < 0
C     X(A,B) = (A+B) * (X(0,1)+1) - B
C
C     .. SCALAR ARGUMENTS ..
      DOUBLE PRECISION A, B
      INTEGER IFAIL, ITYPE, NPTS
C     .. ARRAY ARGUMENTS ..
      DOUBLE PRECISION ABSCIS(NPTS), WEIGHT(NPTS)
C     ..
C     .. LOCAL SCALARS ..
      INTEGER I, N
C     .. SUBROUTINE REFERENCES ..
C     D01BAZ
C     ..
      DO I=1,NPTS
         WEIGHT(I) = 0.D0
         ABSCIS(I) = 0.D0
      ENDDO
      IF (A+B.NE.0.D0) GO TO 40
      IFAIL = 2
      RETURN
   40 CALL D01BAZ(-1.D0, +1.D0, ITYPE, NPTS, WEIGHT, ABSCIS, IFAIL)
      DO N=1,NPTS
         WEIGHT(N) = WEIGHT(N)*2.D0*(A+B)/(ABSCIS(N)+1.D0)**2
         IF (A+B.LT.0.D0) WEIGHT(N) = -WEIGHT(N)
         ABSCIS(N) = 2.D0*(A+B)/(ABSCIS(N)+1.D0) - B
      ENDDO
      RETURN
      END
      SUBROUTINE D01BAZ(A, B, ITYPE, NPTS, WEIGHT, ABSCIS, IFAIL)
C     MARK 7 RELEASE. NAG COPYRIGHT 1978.
C
C     RETURNS WEIGHTS AND PIVOTS FOR ONE GAUSS-LEGENDRE FORMULA IF
C     STORED
C     IFAIL = 1 - THE NPTS RULE IS NOT AMONG THOSE STORED
C     ( WEIGHT,ABSCIS EVALUATED FOR LARGEST VALID NPTS LESS THAN
C     REQUESTED VALUE)
C
C     THE WEIGHTS AND ABSCISSAE RETURNED DEPEND ON A AND B.
C     THOSE STORED ARE WEIGHTS AND ABSCISSAE FOR A=-1,B=+1
C     THOSE RETURNED FOR GENERAL (A,B) ARE RELATED TO THOSE STORED
C     BY
C     W(A,B) = 0.5 * (B-A) * W(-1,+1)
C     X(A,B) = 0.5 * (B-A) * X(-1,+1) +0.5 * (A+B)
C
C     .. SCALAR ARGUMENTS ..
      DOUBLE PRECISION A, B
      INTEGER IFAIL, ITYPE, NPTS
C     .. ARRAY ARGUMENTS ..
      DOUBLE PRECISION ABSCIS(NPTS), WEIGHT(NPTS)
C     ..
C     .. LOCAL SCALARS ..
      DOUBLE PRECISION HFRNGE, PNTMID
      INTEGER I, IIJJ, N, NL, NN, NPTSA
C     .. LOCAL ARRAYS ..
      DOUBLE PRECISION ABST(136), WTST(136)
      INTEGER NSTOR(16)
C     ..
      DATA WTST( 1),WTST( 2),WTST( 3),WTST( 4),WTST( 5)/+
     *0.200000000000000000000000000000D  1,+
     *0.100000000000000000000000000000D  1,+
     *0.555555555555555555555555555555D  0,+
     *0.888888888888888888888888888888D  0,+
     *0.347854845137453857373063949221D  0/
      DATA WTST( 6),WTST( 7),WTST(08),WTST(09),WTST(10)/+
     *0.652145154862546142626936050778D  0,+
     *0.236926885056189087514264040719D  0,+
     *0.478628670499366468041291514835D  0,+
     *0.568888888888888888888888888888D  0,+
     *0.171324492379170345040296142172D  0/
      DATA WTST(11),WTST(12),WTST(13),WTST(14),WTST(15)/+
     *0.360761573048138607569833513837D  0,+
     *0.467913934572691047389870343989D  0,+
     *0.101228536290376259152531354309D  0,+
     *0.222381034453374470544355994426D  0,+
     *0.313706645877887287337962201986D  0/
      DATA WTST(16),WTST(17),WTST(18),WTST(19),WTST(20)/+
     *0.362683783378361982965150449277D  0,+
     *0.666713443086881375935688098933D -1,+
     *0.149451349150580593145776339657D  0,+
     *0.219086362515982043995534934228D  0,+
     *0.269266719309996355091226921569D  0/
      DATA WTST(21),WTST(22),WTST(23),WTST(24),WTST(25)/+
     *0.295524224714752870173892994651D  0,+
     *0.471753363865118271946159614850D -1,+
     *0.106939325995318430960254718193D  0,+
     *0.160078328543346226334652529543D  0,+
     *0.203167426723065921749064455809D  0/
      DATA WTST(26),WTST(27),WTST(28),WTST(29),WTST(30)/+
     *0.233492536538354808760849898924D  0,+
     *0.249147045813402785000562436042D  0,+
     *0.351194603317518630318328761381D -1,+
     *0.801580871597602098056332770628D -1,+
     *0.121518570687903184689414809072D  0/
      DATA WTST(31),WTST(32),WTST(33),WTST(34),WTST(35)/+
     *0.157203167158193534569601938623D  0,+
     *0.185538397477937813741716590125D  0,+
     *0.205198463721295603965924065661D  0,+
     *0.215263853463157790195876443316D  0,+
     *0.271524594117540948517805724560D -1/
      DATA WTST(36),WTST(37),WTST(38),WTST(39),WTST(40)/+
     *0.622535239386478928628438369943D -1,+
     *0.951585116824927848099251076022D -1,+
     *0.124628971255533872052476282192D  0,+
     *0.149595988816576732081501730547D  0,+
     *0.169156519395002538189312079030D  0/
      DATA WTST(41),WTST(42),WTST(43),WTST(44),WTST(45)/+
     *0.182603415044923588866763667969D  0,+
     *0.189450610455068496285396723208D  0,+
     *0.176140071391521183118619623518D -1,+
     *0.406014298003869413310399522749D -1,+
     *0.626720483341090635695065351870D -1/
      DATA WTST(46),WTST(47),WTST(48),WTST(49),WTST(50)/+
     *0.832767415767047487247581432220D -1,+
     *0.101930119817240435036750135480D  0,+
     *0.118194531961518417312377377711D  0,+
     *0.131688638449176626898494499748D  0,+
     *0.142096109318382051329298325067D  0/
      DATA WTST(51),WTST(52),WTST(53),WTST(54),WTST(55)/+
     *0.149172986472603746787828737001D  0,+
     *0.152753387130725850698084331955D  0,+
     *0.123412297999871995468056670700D -1,+
     *0.285313886289336631813078159518D -1,+
     *0.442774388174198061686027482113D -1/
      DATA WTST(56),WTST(57),WTST(58),WTST(59),WTST(60)/+
     *0.592985849154367807463677585001D -1,+
     *0.733464814110803057340336152531D -1,+
     *0.861901615319532759171852029837D -1,+
     *0.976186521041138882698806644642D -1,+
     *0.107444270115965634782577342446D  0/
      DATA WTST(61),WTST(62),WTST(63),WTST(64),WTST(65)/+
     *0.115505668053725601353344483906D  0,+
     *0.121670472927803391204463153476D  0,+
     *0.125837456346828296121375382511D  0,+
     *0.127938195346752156974056165224D  0,+
     *0.701861000947009660040706373885D -2/
      DATA WTST(66),WTST(67),WTST(68),WTST(69),WTST(70)/+
     *0.162743947309056706051705622063D -1,+
     *0.253920653092620594557525897892D -1,+
     *0.342738629130214331026877322523D -1,+
     *0.428358980222266806568786466061D -1,+
     *0.509980592623761761961632446895D -1/
      DATA WTST( 71),WTST( 72),WTST( 73),WTST( 74),WTST( 75)/+
     *0.586840934785355471452836373001D -1,+
     *0.658222227763618468376500637069D -1,+
     *0.723457941088485062253993564784D -1,+
     *0.781938957870703064717409188283D -1,+
     *0.833119242269467552221990746043D -1/
      DATA WTST( 76),WTST( 77),WTST( 78),WTST( 79),WTST( 80)/+
     *0.876520930044038111427714627518D -1,+
     *0.911738786957638847128685771116D -1,+
     *0.938443990808045656391802376681D -1,+
     *0.956387200792748594190820022041D -1,+
     *0.965400885147278005667648300635D -1/
      DATA WTST( 81),WTST( 82),WTST( 83),WTST( 84),WTST( 85)/+
     *0.315334605230583863267731154389D -2,+
     *0.732755390127626210238397962178D -2,+
     *0.114772345792345394895926676090D -1,+
     *0.155793157229438487281769558344D -1,+
     *0.196161604573555278144607196522D -1/
      DATA WTST( 86),WTST( 87),WTST( 88),WTST( 89),WTST( 90)/+
     *0.235707608393243791405193013784D -1,+
     *0.274265097083569482000738362625D -1,+
     *0.311672278327980889020657568463D -1,+
     *0.347772225647704388925485859638D -1,+
     *0.382413510658307063172172565237D -1/
      DATA WTST( 91),WTST( 92),WTST( 93),WTST( 94),WTST( 95)/+
     *0.415450829434647492140588223610D -1,+
     *0.446745608566942804194485871258D -1,+
     *0.476166584924904748259066234789D -1,+
     *0.503590355538544749578076190878D -1,+
     *0.528901894851936670955050562646D -1/
      DATA WTST( 96),WTST( 97),WTST( 98),WTST( 99),WTST(100)/+
     *0.551995036999841628682034951916D -1,+
     *0.572772921004032157051502346847D -1,+
     *0.591148396983956357464748174335D -1,+
     *0.607044391658938800529692320278D -1,+
     *0.620394231598926639041977841375D -1/
      DATA WTST(101),WTST(102),WTST(103),WTST(104),WTST(105)/+
     *0.631141922862540256571260227502D -1,+
     *0.639242385846481866239062018255D -1,+
     *0.644661644359500822065041936577D -1,+
     *0.647376968126839225030249387365D -1,+
     *0.178328072169643294729607914497D -2/
      DATA WTST(106),WTST(107),WTST(108),WTST(109),WTST(110)/+
     *0.414703326056246763528753572855D -2,+
     *0.650445796897836285611736039998D -2,+
     *0.884675982636394772303091465973D -2,+
     *0.111681394601311288185904930192D -1,+
     *0.134630478967186425980607666859D -1/
      DATA WTST(111),WTST(112),WTST(113),WTST(114),WTST(115)/+
     *0.157260304760247193219659952975D -1,+
     *0.179517157756973430850453020011D -1,+
     *0.201348231535302093723403167285D -1,+
     *0.222701738083832541592983303841D -1,+
     *0.243527025687108733381775504090D -1/
      DATA WTST(116),WTST(117),WTST(118),WTST(119),WTST(120)/+
     *0.263774697150546586716917926252D -1,+
     *0.283396726142594832275113052002D -1,+
     *0.302346570724024788679740598195D -1,+
     *0.320579283548515535854675043478D -1,+
     *0.338051618371416093915654821107D -1/
      DATA WTST(121),WTST(122),WTST(123),WTST(124),WTST(125)/+
     *0.354722132568823838106931467152D -1,+
     *0.370551285402400460404151018095D -1,+
     *0.385501531786156291289624969468D -1,+
     *0.399537411327203413866569261283D -1,+
     *0.412625632426235286101562974736D -1/
      DATA WTST(126),WTST(127),WTST(128),WTST(129),WTST(130)/+
     *0.424735151236535890073397679088D -1,+
     *0.435837245293234533768278609737D -1,+
     *0.445905581637565630601347100309D -1,+
     *0.454916279274181444797709969712D -1,+
     *0.462847965813144172959532492322D -1/
      DATA WTST(131),WTST(132),WTST(133),WTST(134),WTST(135)/+
     *0.469681828162100173253262857545D -1,+
     *0.475401657148303086622822069442D -1,+
     *0.479993885964583077281261798713D -1,+
     *0.483447622348029571697695271580D -1,+
     *0.485754674415034269347990667839D -1/
      DATA WTST(136)/+0.486909570091397203833653907347D  -1/
      DATA ABST( 1),ABST( 2),ABST( 3),ABST( 4),ABST( 5)/+
     *0.000000000000000000000000000000D  0,+
     *0.577350269189625764509148780501D  0,+
     *0.774596669241483377035853079956D  0,+
     *0.000000000000000000000000000000D  0,+
     *0.861136311594052575223946488892D  0/
      DATA ABST( 6),ABST( 7),ABST( 8),ABST( 9),ABST(10)/+
     *0.339981043584856264802665759103D  0,+
     *0.906179845938663992797626878299D  0,+
     *0.538469310105683091036314420700D  0,+
     *0.000000000000000000000000000000D  0,+
     *0.932469514203152027812301554493D  0/
      DATA ABST(11),ABST(12),ABST(13),ABST(14),ABST(15)/+
     *0.661209386466264513661399595019D  0,+
     *0.238619186083196908630501721680D  0,+
     *0.960289856497536231683560868569D  0,+
     *0.796666477413626739591553936475D  0,+
     *0.525532409916328985817739049189D  0/
      DATA ABST(16),ABST(17),ABST(18),ABST(19),ABST(20)/+
     *0.183434642495649804939476142360D  0,+
     *0.973906528517171720077964012084D  0,+
     *0.865063366688984510732096688423D  0,+
     *0.679409568299024406234327365114D  0,+
     *0.433395394129247190799265943165D  0/
      DATA ABST(21),ABST(22),ABST(23),ABST(24),ABST(25)/+
     *0.148874338981631210884826001129D  0,+
     *0.981560634246719250690549090149D  0,+
     *0.904117256370474856678465866119D  0,+
     *0.769902674194304687036893833212D  0,+
     *0.587317954286617447296702418940D  0/
      DATA ABST(26),ABST(27),ABST(28),ABST(29),ABST(30)/+
     *0.367831498998180193752691536643D  0,+
     *0.125233408511468915472441369463D  0,+
     *0.986283808696812338841597266704D  0,+
     *0.928434883663573517336391139377D  0,+
     *0.827201315069764993189794742650D  0/
      DATA ABST(31),ABST(32),ABST(33),ABST(34),ABST(35)/+
     *0.687292904811685470148019803019D  0,+
     *0.515248636358154091965290718551D  0,+
     *0.319112368927889760435671824168D  0,+
     *0.108054948707343662066244650219D  0,+
     *0.989400934991649932596154173450D  0/
      DATA ABST(36),ABST(37),ABST(38),ABST(39),ABST(40)/+
     *0.944575023073232576077988415534D  0,+
     *0.865631202387831743880467897712D  0,+
     *0.755404408355003033895101194847D  0,+
     *0.617876244402643748446671764048D  0,+
     *0.458016777657227386342419442983D  0/
      DATA ABST(41),ABST(42),ABST(43),ABST(44),ABST(45)/+
     *0.281603550779258913230460501460D  0,+
     *0.950125098376374401853193354249D -1,+
     *0.993128599185094924786122388471D  0,+
     *0.963971927277913791267666131197D  0,+
     *0.912234428251325905867752441203D  0/
      DATA ABST(46),ABST(47),ABST(48),ABST(49),ABST(50)/+
     *0.839116971822218823394529061701D  0,+
     *0.746331906460150792614305070355D  0,+
     *0.636053680726515025452836696226D  0,+
     *0.510867001950827098004364050955D  0,+
     *0.373706088715419560672548177024D  0/
      DATA ABST(51),ABST(52),ABST(53),ABST(54),ABST(55)/+
     *0.227785851141645078080496195368D  0,+
     *0.765265211334973337546404093988D -1,+
     *0.995187219997021360179997409700D  0,+
     *0.974728555971309498198391993008D  0,+
     *0.938274552002732758523649001708D  0/
      DATA ABST(56),ABST(57),ABST(58),ABST(59),ABST(60)/+
     *0.886415527004401034213154341982D  0,+
     *0.820001985973902921953949872669D  0,+
     *0.740124191578554364243828103099D  0,+
     *0.648093651936975569252495786910D  0,+
     *0.545421471388839535658375617218D  0/
      DATA ABST(61),ABST(62),ABST(63),ABST(64),ABST(65)/+
     *0.433793507626045138487084231913D  0,+
     *0.315042679696163374386793291319D  0,+
     *0.191118867473616309158639820757D  0,+
     *0.640568928626056260850430826247D -1,+
     *0.997263861849481563544981128665D  0/
      DATA ABST(66),ABST(67),ABST(68),ABST(69),ABST(70)/+
     *0.985611511545268335400175044630D  0,+
     *0.964762255587506430773811928118D  0,+
     *0.934906075937739689170919134835D  0,+
     *0.896321155766052123965307243719D  0,+
     *0.849367613732569970133693004967D  0/
      DATA ABST( 71),ABST( 72),ABST( 73),ABST( 74),ABST( 75)/+
     *0.794483795967942406963097298970D  0,+
     *0.732182118740289680387426665091D  0,+
     *0.663044266930215200975115168663D  0,+
     *0.587715757240762329040745476401D  0,+
     *0.506899908932229390023747474377D  0/
      DATA ABST( 76),ABST( 77),ABST( 78),ABST( 79),ABST( 80)/+
     *0.421351276130635345364119436172D  0,+
     *0.331868602282127649779916805730D  0,+
     *0.239287362252137074544603209165D  0,+
     *0.144471961582796493485186373598D  0,+
     *0.483076656877383162348125704405D -1/
      DATA ABST( 81),ABST( 82),ABST( 83),ABST( 84),ABST( 85)/+
     *0.998771007252426118600541491563D  0,+
     *0.993530172266350757547928750849D  0,+
     *0.984124583722826857744583600026D  0,+
     *0.970591592546247250461411983800D  0,+
     *0.952987703160430860722960666025D  0/
      DATA ABST( 86),ABST( 87),ABST( 88),ABST( 89),ABST( 90)/+
     *0.931386690706554333114174380101D  0,+
     *0.905879136715569672822074835671D  0,+
     *0.876572020274247885905693554805D  0,+
     *0.843588261624393530711089844519D  0,+
     *0.807066204029442627082553043024D  0/
      DATA ABST( 91),ABST( 92),ABST( 93),ABST( 94),ABST( 95)/+
     *0.767159032515740339253855437522D  0,+
     *0.724034130923814654674482233493D  0,+
     *0.677872379632663905211851280675D  0,+
     *0.628867396776513623995164933069D  0,+
     *0.577224726083972703817809238540D  0/
      DATA ABST( 96),ABST( 97),ABST( 98),ABST( 99),ABST(100)/+
     *0.523160974722233033678225869137D  0,+
     *0.466902904750958404544928861650D  0,+
     *0.408686481990716729916225495814D  0,+
     *0.348755886292160738159817937270D  0,+
     *0.287362487355455576735886461316D  0/
      DATA ABST(101),ABST(102),ABST(103),ABST(104),ABST(105)/+
     *0.224763790394689061224865440174D  0,+
     *0.161222356068891718056437390783D  0,+
     *0.970046992094626989300539558536D -1,+
     *0.323801709628693620333222431521D -1,+
     *0.999305041735772139456905624345D  0/
      DATA ABST(106),ABST(107),ABST(108),ABST(109),ABST(110)/+
     *0.996340116771955279346924500676D  0,+
     *0.991013371476744320739382383443D  0,+
     *0.983336253884625956931299302156D  0,+
     *0.973326827789910963741853507352D  0,+
     *0.961008799652053718918614121897D  0/
      DATA ABST(111),ABST(112),ABST(113),ABST(114),ABST(115)/+
     *0.946411374858402816062481491347D  0,+
     *0.929569172131939575821490154559D  0,+
     *0.910522137078502805756380668008D  0,+
     *0.889315445995114105853404038272D  0,+
     *0.865999398154092819760783385070D  0/
      DATA ABST(116),ABST(117),ABST(118),ABST(119),ABST(120)/+
     *0.840629296252580362751691544695D  0,+
     *0.813265315122797559741923338086D  0,+
     *0.783972358943341407610220525213D  0,+
     *0.752819907260531896611863774885D  0,+
     *0.719881850171610826848940217831D  0/
      DATA ABST(121),ABST(122),ABST(123),ABST(124),ABST(125)/+
     *0.685236313054233242563558371031D  0,+
     *0.648965471254657339857761231993D  0,+
     *0.611155355172393250248852971018D  0,+
     *0.571895646202634034283878116659D  0,+
     *0.531279464019894545658013903544D  0/
      DATA ABST(126),ABST(127),ABST(128),ABST(129),ABST(130)/+
     *0.489403145707052957478526307021D  0,+
     *0.446366017253464087984947714758D  0,+
     *0.402270157963991603695766771260D  0,+
     *0.357220158337668115950442615046D  0,+
     *0.311322871990210956157512698560D  0/
      DATA ABST(131),ABST(132),ABST(133),ABST(134),ABST(135)/+
     *0.264687162208767416373964172510D  0,+
     *0.217423643740007084149648748988D  0,+
     *0.169644420423992818037313629748D  0,+
     *0.121462819296120554470376463492D  0,+
     *0.729931217877990394495429419403D -1/
      DATA ABST(136)/+0.243502926634244325089558428537D  -1/
      DATA NSTOR(1), NSTOR(2), NSTOR(3), NSTOR(4) /1,2,3,4/
      DATA NSTOR(5), NSTOR(6), NSTOR(7), NSTOR(8) /5,6,8,10/
      DATA NSTOR(9), NSTOR(10), NSTOR(11), NSTOR(12) /12,14,16,20/
      DATA NSTOR(13), NSTOR(14), NSTOR(15), NSTOR(16) /24,32,48,64/
      DO I=1,NPTS
         WEIGHT(I) = 0.D0
         ABSCIS(I) = 0.D0
      ENDDO
      N = 0
      NPTSA = 0
      IFAIL = 0
      DO I=1,16
         IF (NPTS.LT.NSTOR(I)) EXIT
         N = N + (NPTSA+1)/2
         NPTSA = NSTOR(I)
         IF (NPTS.EQ.NSTOR(I)) GO TO 100
      ENDDO
      IFAIL = 1
  100 HFRNGE = 0.5D0*(B-A)
      PNTMID = 0.5D0*(A+B)
      NL = NPTSA/2
C     IF (NL.LT.1) GO TO 140
      DO NN=1,NL
         N = N + 1
         IIJJ = NPTSA + 1 - NN
         ABSCIS(NN) = HFRNGE*ABST(N) + PNTMID
         WEIGHT(NN) = HFRNGE*WTST(N)
         ABSCIS(IIJJ) = -HFRNGE*ABST(N)+ PNTMID
         WEIGHT(IIJJ) = HFRNGE*WTST(N)
      ENDDO
  140 IF (NPTSA.LE.(NL+NL)) RETURN
      N = N + 1
      ABSCIS(NL+1) = HFRNGE*ABST(N) + PNTMID
      WEIGHT(NL+1) = HFRNGE*WTST(N)
      RETURN
      END
      SUBROUTINE D01BBF(WTFUN, A, B, ITYPE, NPTS, WEIGHT, ABSCIS,IFAIL)
C     MARK 7 RELEASE. NAG COPYRIGHT 1978.
C
C     RETURNS WEIGHTS AND PIVOTS FOR ONE GAUSS-WTFUN FORMULA IF
C     STORED
C     IFAIL = 1 - THE NPTS RULE IS NOT AMONG THOSE STORED
C     ( WEIGHT,ABSCIS EVALUATED FOR LARGEST VALID NPTS LESS THAN
C     REQUESTED VALUE)
C     IFAIL = 2 - VALUES OF A OR B INVALID
C     ( ALL WEIGHTS AND ABSCISSAE RETURNED AS ZERO)
C     IFAIL = 3 - UNDERFLOW IN EVALUATING LAGUERRE OR HERMITE
C     NORMAL WEIGHTS
C     ( THE UNDERFLOWING WEIGHTS ARE RETURNED AS ZERO)
C
C     THE WEIGHTS AND ABSCISSAE RETURNED DEPEND ON A AND B.
C
C     .. SCALAR ARGUMENTS ..
      DOUBLE PRECISION A, B
      INTEGER IFAIL, ITYPE, NPTS
C     .. ARRAY ARGUMENTS ..
      DOUBLE PRECISION ABSCIS(NPTS), WEIGHT(NPTS)
C     .. SUBROUTINE ARGUMENTS ..
C     WTFUN
C     ..
C     .. LOCAL SCALARS ..
C$P 1
      CHARACTER(8) SRNAME
      INTEGER IERR
C     .. FUNCTION REFERENCES ..
      INTEGER P01AAF
C     ..
      DATA SRNAME /' D01BBF '/
      CALL WTFUN(A, B, ITYPE, NPTS, WEIGHT, ABSCIS, IERR)
      IF (IERR.EQ.0) GO TO 20
      IFAIL = P01AAF(IFAIL,IERR,SRNAME)
      RETURN
   20 IFAIL = 0
      RETURN
      END

      SUBROUTINE HERM(H,N,X)
C  Copyright (C) 2022 J. M. Hutson & C. R. Le Sueur
C  Distributed under the GNU General Public License, version 3
C
C  SUBROUTINE TO GENERATE HERMITE POLYNOMIALS USING RECURSION FORMULA
C  HK(X)=2X*HK-1(X)-(2K-4)HK-2(X) AND HK(X) CONTAINS THE HERMITE
C  POLYNOMIAL H_{K-1}(X)
C
C  ON ENTRY: N IS NUMBER OF HERMITE POLYNOMIALS;
C            X IS POSITION AT WHICH HERMITE POLYNOMIALS ARE EVALUATED.
C            UNCHANGED ON EXIT.
C  ON EXIT:  H CONTAINS THE VALUES OF THE HERMITE POLYNOMIALS AT X.
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION H(N)

      P0=1.D0
      H(1)=P0
      IF (N.LE.1) RETURN
      X2=X+X
      P1=X2
      H(2)=P1
      IF (N.LE.2) RETURN

      DO K=3,N
        TEMP=X2*P1 - DBLE(K+K-4)*P0
        P0=P1
        P1=TEMP
        H(K)=P1
      ENDDO

      RETURN
      END


      FUNCTION FACTORIAL(N)
      IMPLICIT NONE
C-----------------------------------------------------------------------
C  DATE (LAST UPDATE): 19/06/12       STATUS: FINISHED, TESTED         |
C  AUTHOR: MAYKEL LEONARDO GONZALEZ MARTINEZ                           |
C-----------------------------------------------------------------------
C             THIS FUNCTION EVALUATES THE FACTORIAL OF N               |
C    (IT USES A VERY SIMPLE ALGORITHM, IT SHOULD BE OK FOR SMALL N)    |
C-----------------------------------------------------------------------
      INTEGER N,FCT10(0:10),I
      INTEGER*8 FACTORIAL
      DATA FCT10/1,1,2,6,24,120,720,5040,40320,362880,3628800/
C
      SELECT CASE (N)
      CASE (:-1)
         STOP " ERROR IN FACTORIAL: N < 0"
      CASE (0:10)
         FACTORIAL=FCT10(N)
      CASE DEFAULT
         FACTORIAL=FCT10(10)
         DO I=11,N
            FACTORIAL=FACTORIAL*I
         END DO
      END SELECT
C
      RETURN
      END FUNCTION FACTORIAL

      
        SUBROUTINE MATPRN(IUNIT,X,NDIM,N,NC,ISY,X2,A,MDIM)
C  Copyright (C) 2019 J. M. Hutson & C. R. Le Sueur
C  Distributed under the GNU General Public License, version 3
C
C  USAGE OF PARAMETERS :
C  IUNIT : FORTRAN CHANNEL NUMBER
C  X     : MATRIX FOR PRINTING IF IN 2-D ARRAY
C  NDIM  : FIRST DIM. OF X AS DECLARED IN CALLING PROCEDURE
C  N     : NO. OF ROWS (I.E. FIRST DIM.) TO BE PRINTED
C  NC    : NO. OF COLUMNS (I.E. SECOND DIM.) TO BE PRINTED
C  ISY   : SEE BELOW
C  X2    : MATRIX FOR PRINTING IF IN SYMMETRIC STORAGE MODE
C  A     : *-CHARACTER TITLE
C  MDIM  : SIZE OF ARRAY NECESSARY FOR STORING X2
C
C      USE OF ISYM---
C
C            MATRIX              OUTPUT
C
C  ISYM=0  SYMMETRIC           F FORMAT
C  ISYM=1  FULL                F FORMAT
C  ISYM=2  SYMMETRIC           E FORMAT
C  ISYM=3  FULL                E FORMAT
C  ISYM=4  SYM STORAGE         F FORMAT
C  ISYM=5  SYM STORAGE         E FORMAT
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(NDIM,NC),X2(MDIM)
      CHARACTER*(*) A

      ISYM=ISY
      ITIME=(NC+9)/10
      KF=0
      KF1=KF
      ISTOR=0
      IFMT=20
      IF (ISYM.LE.3) GOTO 4
      ISTOR=1
      IF (ISYM.EQ.5) IFMT=21
      ISYM=0
      GOTO 3
    4 IF (ISYM.LE.1) GOTO 3
      ISYM=ISYM-2
      IFMT=21
    3 CONTINUE
      WRITE(IUNIT,16)
      J1=1
      DO KK=1,ITIME
C  PRINT HEADING AND COLUMN NUMBERS
        KS=(KK-1)*10 + 1
        KF=KS + 9
        KF1=KF
        IF (KK.EQ.ITIME) KF1=MIN(NC,KF)
        WRITE(IUNIT,*) A
        WRITE(IUNIT,11) (I,I=KS,KF1)
        IF (ISYM.EQ.0) J1=KS
        DO JJ=J1,N
C  SYMMETRIC PRINTING
          IF (ISYM.EQ.0) KF1=MIN(JJ,KF)
          IF (ISTOR.EQ.1) GOTO 199
          IF (IFMT.EQ.20) WRITE(IUNIT,20) JJ,(X(JJ,I),I=KS,KF1)
          IF (IFMT.EQ.21) WRITE(IUNIT,21) JJ,(X(JJ,I),I=KS,KF1)
          CYCLE
C  PRINTING FOR MATRICES IN SYM STORAGE MODE
  199     II1=JJ*(JJ-1)/2
          IF (IFMT.EQ.20) WRITE(IUNIT,20) JJ,(X2(II1+I),I=KS,KF1)
          IF (IFMT.EQ.21) WRITE(IUNIT,21) JJ,(X2(II1+I),I=KS,KF1)
        ENDDO
        WRITE(IUNIT,16)
      ENDDO
      RETURN
C  FORMATS MODIFIED BY JA ON 01/12/2008
C  ORIGINAL FORMATS:
C  11 FORMAT(/10(10X,I2))
C  20 FORMAT(' ',I2,10(1X,F11.5))
C  21 FORMAT(' ',I2,10E12.5)
C  NEW FORMATS:
   11 FORMAT(/3X,10(14X,I3))
   20 FORMAT(' ',I5,10(1X,F16.10))
   21 FORMAT(' ',I5,10(1X,E16.9))
C************************************
   16 FORMAT(//)
      END

